@echo off
color fc

rem Change the following if required for your installation
set CW_HOME=C:\Program Files (x86)\Freescale
if not exist "%CW_HOME%" set CW_HOME=C:\Program Files\Freescale
cls
echo. 
echo ********************************************************** 
echo This script should be run as Administrator under Vista
echo (Right-click and select "Runs as administrator")
echo ********************************************************** 
echo.
echo This script will modify your Codewarrior installation(s)!
echo.
echo It assumes Codewarrior has been installed to the default location:
echo.
echo %CW_HOME% 
echo.
echo Modify if necessary
echo.
echo You should check the contents of this file before continuing.
echo.
echo Press CTRL-C to abort or any other key to continue.
echo.
pause
cls

set HOME_DIR=%~dp0

set SOURCE_DIR=%HOME_DIR%Release_DLLs
if exist "%SOURCE_DIR%" goto okSourceDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Installation files not found:                 *
echo *                                                 *     
echo *   Please UNZIP Release_DLLs.zip and try again   *
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okSourceDirectory

set UTILITIES_DIR=%HOME_DIR%Utilities
if exist "%UTILITIES_DIR%" goto okUtilitiesDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Installation files not found:                 *
echo *                                                 *     
echo *   Please UNZIP Utilities.zip and try again      *
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okUtilitiesDirectory

if exist "%CW_HOME%" goto okParentDirectory
cls
echo.
echo.
echo ***************************************************
echo *                     ERROR                       *     
echo *                                                 *     
echo *   Codewarrior directory not found:              *
echo *                                                 *     
echo *   "%CW_HOME%"
echo *                                                 *     
echo *   Installation failed.                          *
echo *                                                 *     
echo ***************************************************
echo.
echo.
goto finish
:okParentDirectory

rem Change the following if required for your installation
set CW_HCS12_DIR=%CW_HOME%\CWS12v5.1
set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.3
set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.2
set CW_DSC_DIR=%CW_HOME%\CodeWarrior for DSC56800E v8.3
set CW_ECLIPSE_DIR=%CW_HOME%\CW MCU v10.1

set ECLIPSE_VER=10_1
rem set NOICE_DIR=C:\Program Files\NoICE

rem echo Copying files from %SOURCE_DIR%
rem echo.

rem This tries to locate the Codewarrior directories if the above are not found
rem --------------------------------------------------------------------------------
if not exist "%CW_ECLIPSE_DIR%" set CW_ECLIPSE_DIR=%CW_HOME%\CW MCU v10.1

if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\CWS12v5.1
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\CodeWarrior for S12(X) V5.0
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.7
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.6
if not exist "%CW_HCS12_DIR%" set CW_HCS12_DIR=%CW_HOME%\Codewarrior for HCS12 V4.5

if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.3
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.2
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.1
if not exist "%CW_HCS08_DIR%" set CW_HCS08_DIR=%CW_HOME%\CodeWarrior for Microcontrollers V6.0

if not exist "%CW_CFVx_DIR%"  set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.1
if not exist "%CW_CFVx_DIR%"  set CW_CFVx_DIR=%CW_HOME%\CodeWarrior for ColdFire V7.0

if not exist "%CW_DSC_DIR%" set CW_DSC_DIR=%CW_HOME%\CodeWarrior for DSC56800E v8.3

rem =======================================================================================================
rem set JAR_DIR=net.sourceforge.usbdm.connections.usbdm_4.4.0.v201102151129
rem set JAR_DIR=net.sourceforge.usbdm.connections.usbdm_4.4.0.v201101091533
rem set JAR_DIR=net.sourceforge.usbdm.connections.usbdm_4.5.0.v201102161214
rem set JAR_DIR=net.sourceforge.usbdm.connections.usbdm_4.6.0.v201102241540
set JAR_DIR=net.sourceforge.usbdm.connections.usbdm_4.6.0.v201102241540

set DESTINATION="%APPDATA%\usbdm"

if not exist %DESTINATION% goto noAPPDATADirectory
echo Cleaning %DESTINATION% directory
echo ===========================================================
del /Q %DESTINATION%\*.*
:noAPPDATADirectory

if exist %DESTINATION% goto okAPPDATADirectory
echo ===========================================================
echo Creating %DESTINATION% directory
mkdir %DESTINATION%
:okAPPDATADirectory

echo ===========================================================
set FILES="JTAG_Devices.cfg" 
echo Copying %FILES% to APPDATA\usbdm
for %%f in (%FILES%) do copy "%UTILITIES_DIR%\"%%f %DESTINATION%
set FILES="cfv1_devices.xml" "hcs08_devices.xml" "hcs12_devices.xml" "rs08_devices.xml" "CFVx_devices.xml" "ARM_devices.xml" "usbdmDeviceSchema.dtd"
echo Copying %FILES% to APPDATA\usbdm
for %%f in (%FILES%) do copy "%UTILITIES_DIR%\"%%f %DESTINATION%
set FILES="CFV1" "CFVx" "Arm"
echo Copying %FILES% to APPDATA\usbdm
for %%d in (%FILES%) do xcopy /Y /I "%UTILITIES_DIR%\"%%d %DESTINATION%\%%d
echo.

rem ====================================================================================================
rem Codewarrior Development Studio (Eclipse)
if not exist "%CW_ECLIPSE_DIR%"  goto skippedCW_ECLIPSE

set ECLIPSE_ARM="%CW_ECLIPSE_DIR%\MCU\bin\plugins\support\Arm\gdi"
set ECLIPSE_CF="%CW_ECLIPSE_DIR%\MCU\bin\plugins\support\ColdFire\gdi"
set ECLIPSE_HCS="%CW_ECLIPSE_DIR%\MCU\bin\plugins\support\HC08\gdi"
set ECLIPSE_PLUGIN="%CW_ECLIPSE_DIR%\eclipse\plugins"
set ECLIPSE_LAUNCH_DIR="%CW_ECLIPSE_DIR%\MCU\lib\wizard_data\launch_config

echo "Installing USBDM files for Codewarrior for MCU (Eclipse)"
echo ===========================================================

rem Delete old versions (with different names)
if not exist %ECLIPSE_HCS%\USBDM_GDI_HCS08.dll goto noDeleteOldEclipseFiles
set FILES=USBDM_GDI_HCS08.dll USBDM_GDI_RS08.dll
echo Deleting %FILES%
for %%f in (%FILES%) do del %ECLIPSE_HCS%\%%f
set FILES=USBDM_GDI_CFV1.dll USBDM_GDI_CFVx.dll
echo Deleting %FILES%
for %%f in (%FILES%) do del %ECLIPSE_CF%\%%f

:noDeleteOldEclipseFiles
rem Copy common files
set FILES=libxerces-c-3-1.dll libusb-1.0.dll tcl85.dll wxPlugin.dll usbdm.4.dll usbdm-arm.4.dll usbdmtcl.4.dll 
echo Copying %FILES% to ECLIPSE_HCS
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %ECLIPSE_HCS%
echo Copying %FILES% to ECLIPSE_CF
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %ECLIPSE_CF%
echo Copying %FILES% to ECLIPSE_ARM
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %ECLIPSE_ARM%
rem Copy version specific files
set FILES=usbdm-hcs08-gdi.dll usbdm-rs08-gdi.dll 
echo Copying %FILES% to ECLIPSE_HCS
for %%f in (%FILES%) do copy "%SOURCE_DIR%\CW_%ECLIPSE_VER%\%%f" %ECLIPSE_HCS%
set FILES=usbdm-cfv1-gdi.dll usbdm-cfvx-gdi.dll
echo Copying %FILES% to ECLIPSE_CF
for %%f in (%FILES%) do copy "%SOURCE_DIR%\CW_%ECLIPSE_VER%\%%f" %ECLIPSE_CF%
set FILES=usbdm-arm-gdi.dll
echo Copying %FILES% to ECLIPSE_ARM
for %%f in (%FILES%) do copy "%SOURCE_DIR%\CW_%ECLIPSE_VER%\%%f" %ECLIPSE_ARM%
rem Copy plugins
echo Copying %JAR_DIR% to ECLIPSE_PLUGIN
rem copy "%HOME_DIR%\plugins\%JAR_FILE%" %ECLIPSE_PLUGIN%
xcopy /E /Q /R /Y /I "%HOME_DIR%plugins\%JAR_DIR%" %ECLIPSE_PLUGIN%\%JAR_DIR%
echo Done
echo.
:skippedCW_ECLIPSE

rem ====================================================================================================
rem NOICE - not supported at the moment
goto skippedNOICE
if not exist "%NOICE_DIR%\bin"  goto skippedNOICE
echo "Installing USBDM files for NOICE"
echo ===================================
set DESTINATION="%NOICE_DIR%\bin" 
set FILES=tbdml.dll usbdm.4.dll libusb-1.0.dll
set NOICE_TBDML_BACKUP=tbdml_original.dll
if not exist "%NOICE_DIR%\bin\tbdml.dll"  goto skippedNOICEBackup
if exist     "%NOICE_DIR%\bin\%NOICE_TBDML_BACKUP%"  goto skippedNOICEBackup
echo Making backup of existing tbdml.dl file to %NOICE_TBDML_BACKUP%
rename "%NOICE_DIR%\bin\tbdml.dll" "%NOICE_TBDML_BACKUP%" 
:skippedNOICEBackup
echo Copying %FILES%
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %DESTINATION%
echo.
:skippedNOICE

rem ====================================================================================================
rem CodeWarrior for ColdFire
set DESTINATION="%CW_CFVx_DIR%\bin\Plugins\Support\ColdFire\usbdm"
if not exist "%SOURCE_DIR%\tblcf.dll" goto skippedCFVx
if not exist "%CW_CFVx_DIR%" goto skippedCFVx
echo "Installing USBDM/CF files for Codewarrior for Coldfire V2, V3 & V4"
echo =====================================================================
rem delete old files
if not exist %DESTINATION%\tblcf.dll goto noDeleteOldCFVxFiles
set FILES=tblcf.dll tblcf_gdi.dll tblcf.cfg USBDM_GDI_CFVx_Legacy.dll
echo Deleting %FILES%
for %%f in (%FILES%) do del %DESTINATION%\%%f

:noDeleteOldCFVxFiles
set FILES=tblcf.dll tblcf_gdi.dll tblcf.cfg usbdm-cfvx-gdi-legacy.dll usbdm.4.dll libusb-1.0.dll libxerces-c-3-1.dll
if exist %DESTINATION% goto okCFVxInstallDirectory
echo Creating %DESTINATION% directory
mkdir %DESTINATION%
:okCFVxInstallDirectory
echo Copying %FILES%
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %DESTINATION%
echo.
:skippedCFVx

rem ====================================================================================================
rem CodeWarrior for Microcontrollers
if not exist "%CW_HCS08_DIR%" goto skippedHCS08
echo "Installing USBDM files for Codewarrior for RS08/HCS08/Coldfire V1"
echo =======================================================================
set DESTINATION="%CW_HCS08_DIR%\Prog\gdi"
set FILES=opensourcebdm.dll usbdm.4.dll libusb-1.0.dll libxerces-c-3-1.dll
echo Copying %FILES%
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %DESTINATION%
:skippedHCS08

rem ====================================================================================================
rem Codewarrior for HCS12
if not exist "%CW_HCS12_DIR%" goto skippedHCS12
echo "Installing USBDM files for Codewarrior for HCS12"
echo ======================================================
set DESTINATION="%CW_HCS12_DIR%\Prog\gdi"
set FILES=tbdml.dll usbdm.4.dll libusb-1.0.dll libxerces-c-3-1.dll
echo Copying %FILES%
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %DESTINATION%
:skippedHCS12

rem ====================================================================================================
rem CodeWarrior for DSC56800E
set DESTINATION="%CW_DSC_DIR%\bin\Plugins\Support\usbdm"
if not exist "%SOURCE_DIR%\usbdm-dsc-gdi-legacy.dll" goto skippedDSC
if not exist "%CW_DSC_DIR%" goto skippedDSC
echo "Installing USBDM/CF files for CodeWarrior for DSC56800E v8.3"
echo =====================================================================
rem delete old files
if not exist %DESTINATION%\USBDM_GDI_DSC_Legacy.dll goto noDeleteOldDSCFiles
set FILES=USBDM_GDI_DSC_Legacy.dll
echo Deleting %FILES%
for %%f in (%FILES%) do del %DESTINATION%\%%f

:noDeleteOldDSCFiles
set FILES=usbdm-dsc-gdi-legacy.dll usbdm.4.dll libusb-1.0.dll libxerces-c-3-1.dll
if exist %DESTINATION% goto okDSCInstallDirectory
echo Creating %DESTINATION% directory
mkdir %DESTINATION%
:okDSCInstallDirectory
echo Copying %FILES%
for %%f in (%FILES%) do copy "%SOURCE_DIR%\%%f" %DESTINATION%
echo.
:skippedDSC

rem ====================================================================================================

:finish
echo.
echo.
pause